import sys
import logging
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path
logging.getLogger('suds.client').setLevel(logging.CRITICAL)
from time import sleep
from suds.client import Client
import copy
import datetime

from pytz import timezone
from pytz import common_timezones
import pytz
import time

from ReplaceDatabase import ReplaceDatabase

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'GEORGIA'
state_short = 'GA'
domain = 'GA.VA.GOV'
facility1_site_id = '556'
facility2_abbr = 'GVARMC'
facility3_abbr = 'GVAOPC'
patient_ssn = '100000006'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase8Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase8/cache.dat")
sleep(60)

print 'setp 1'
print '\tadd a patient to waiting list'
patients = client.service.SearchPatients(facility1_site_id,patient_ssn)
patient1 = client.service.GetPatient(patients[0])

facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section1 = copy.deepcopy(p)
		break;

resources = client.service.GetAllResources(section1.Id)
for p in resources.Resource:
	if p.Name == 'case 3 provider,one':
		resource1 = copy.deepcopy(p)
		break;
		
appreq = client.factory.create('ns0:AppointmentRequest')

appreq.Patient = patient1
appreq.RequestMethod = 'Email'
appreq.RequestedResource  = resource1
appreq.Status = 'Unknown'
appreq.Reason = 'WaitList'
appreq.Time = datetime.datetime.strptime('2013-05-16 07:00:00', '%Y-%m-%d %H:%M:%S')
result = client.service.AddAppointmentRequest(appreq)
appreq1 = copy.deepcopy(result)

print 'step 2'
print '\tsending waiting list notification to the patient'
comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient1.Id
comqueue.SendBy = datetime.datetime(2013,5,24)
comqueue.SentOn = datetime.datetime(2013,5,23)
comqueue.Subject = 'electronic waiting list notification'
comqueue.Body = 'added to the waiting list.'

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

print 'checkpoint 1'
if logdetail == 1:
	print appreq1
	print comqueue_result
print '\tpatient is listed on the waiting list and notification letter got created'

print 'step 3'
print '\tchecking open resource for an appointment'
result = client.service.GetResourceAvailability(resource1.Id, datetime.datetime(2013,11,11), datetime.datetime(2013,11,13))
#print result

print 'checkpoint 2'
if logdetail == 1:
	print appreq1
	print comqueue_result
print '\tpatient is listed on the waiting list'

print 'step 4'
print 'select a patient from the waiting list where SC > 50%'
#print patient1

print 'step 5'
print 'display patient demographics and contact the patient'
print patient1

print 'step 6'
print 'make the appointment'
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource1
appointment.Patient = patient1
appointment.Length = 30
appointment.Section = resource1.Section
appTimeStamp = datetime.datetime(2013,11,12,19,00,00)
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource1.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment)
    appointment6 = copy.deepcopy(result)
    print appointment6.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

print 'step 7'
print 'remove patient from the EWL'
appreq1.ResultingAppointment = appointment6
appreq1.Status = 'Complete'
result = client.service.UpdateAppointmentRequest(appreq1)
appreq7 = copy.deepcopy(result)

print 'checkpoint 3'
if logdetail == 1:
	print appreq7
print 'verified the patient is removed from EWL'

print 'step 8'
print 'send the appointment notification to the patient'
comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient1.Id
comqueue.SendBy = datetime.datetime(2013,11,14)
comqueue.SentOn = datetime.datetime(2013,11,10)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled.'
comqueue.Appointment = appointment6

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

print 'checkpoint 4'
if logdetail == 1:
	print comqueue_result
print 'verified the existence of the appointment notification for the patient'

print ''
print '------------------------------------------------------------------------------------------------'
print ''
print 'step 1'
print 'add patient request to the transfer list'
for p in facilities.Facility:
	if p.Name == facility3:
		facility3_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility3_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section2 = copy.deepcopy(p)
		break;

resources = client.service.GetAllResources(section2.Id)
for p in resources.Resource:
	if p.Name == 'case2 step 2 provider':
		resource2 = copy.deepcopy(p)
		break;

schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '1'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resource2.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

slots = client.factory.create('ns0:ArrayOfSlot')
slot = client.factory.create('ns0:Slot')
slot.Time = 'PT16H'
slot.Length = 30
slot.Capacity = 1
slot.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot)

slot2 = client.factory.create('ns0:Slot')
slot2.Time = 'PT16H30M'
slot2.Length = 30
slot2.Capacity = 1
slot2.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot2)

slot3 = client.factory.create('ns0:Slot')
slot3.Time = 'PT17H'
slot3.Length = 30
slot3.Capacity = 1
slot3.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot3)

slot4 = client.factory.create('ns0:Slot')
slot4.Time = 'PT17H30M'
slot4.Length = 30
slot4.Capacity = 1
slot4.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot4)

slot5 = client.factory.create('ns0:Slot')
slot5.Time = 'PT18H'
slot5.Length = 30
slot5.Capacity = 1
slot5.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot5)

slot6 = client.factory.create('ns0:Slot')
slot6.Time = 'PT18H30M'
slot6.Length = 30
slot6.Capacity = 1
slot6.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot6)

slot7 = client.factory.create('ns0:Slot')
slot7.Time = 'PT19H'
slot7.Length = 30
slot7.Capacity = 5
slot7.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot7)

slot8 = client.factory.create('ns0:Slot')
slot8.Time = 'PT19H30M'
slot8.Length = 30
slot8.Capacity = 5
slot8.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot8)

slot9 = client.factory.create('ns0:Slot')
slot9.Time = 'PT20H'
slot9.Length = 30
slot9.Capacity = 5
slot9.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot9)

slot10 = client.factory.create('ns0:Slot')
slot10.Time = 'PT20H30M'
slot10.Length = 30
slot10.Capacity = 5
slot10.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot10)
resource2.SchedulingPolicies.SchedulingPolicy[0].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[1].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '3'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[2].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '4'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[3].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '5'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[4].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

appreq = client.factory.create('ns0:AppointmentRequest')
appreq.Patient = patient1
appreq.RequestMethod = 'Email'
appreq.RequestedResource  = resource2
appreq.Status = 'Unknown'
appreq.Reason = 'Transfer'
appreq.Time = datetime.datetime.strptime('2013-05-16 07:00:00', '%Y-%m-%d %H:%M:%S')
result = client.service.AddAppointmentRequest(appreq)
appreq2 = copy.deepcopy(result)
if logdetail == 1:
	print appreq2

print 'step 2'
print '\tsending transfer request notification to the patient'
comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient1.Id
comqueue.SendBy = datetime.datetime(2013,5,24)
comqueue.SentOn = datetime.datetime(2013,5,23)
comqueue.Subject = 'transfer request notification'
comqueue.Body = 'added to the transfer request list.'

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)
if logdetail == 1:
	print comqueue_result
	
print 'step 3'
print '\tchecking transfer request for the new location'
result = client.service.GetResourceAvailability(resource2.Id, datetime.datetime(2013,12,17), datetime.datetime(2013,12,18))
if logdetail == 1:
	print result
	print comqueue_result

print 'step 4'
print 'transfer the patient to new location'
if logdetail == 1:
	print resource2

print 'step 5'
print 'create an appointment on new location'
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource2
appointment.Patient = patient1
appointment.Length = 30
appointment.Section = resource2.Section
appTimeStamp = datetime.datetime(2013,12,17,20,00,00)
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource2.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment)
    appointment5 = copy.deepcopy(result)
    print appointment5.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

print 'step 6'
print 'send the appointment notification to the patient on new location'
comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient1.Id
comqueue.SendBy = datetime.datetime(2013,12,16)
comqueue.SentOn = datetime.datetime(2013,12,15)
comqueue.Subject = 'Pre-appointment notification'
comqueue.Body = 'appointment scheduled on new location.'
comqueue.Appointment = appointment5

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)
if logdetail == 1:
	print comqueue_result